/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.common.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class HexDump {
    final String sMargin = " ";
    InputStream isData;
    byte[] bInputBytes;
    long lOffset;

    public HexDump(byte[] byArray) {
        this.ctrHelper(byArray, true, 0, byArray == null ? 0 : byArray.length);
    }

    public HexDump(byte[] byArray, int n, int n2) {
        this.ctrHelper(byArray, true, n, n2);
    }

    public HexDump(byte[] byArray, int n, int n2, boolean bl) {
        this.ctrHelper(byArray, bl, n, n2);
    }

    public HexDump(byte[] byArray, boolean bl) {
        this.ctrHelper(byArray, bl, 0, byArray == null ? 0 : byArray.length);
    }

    private final void ctrHelper(byte[] byArray, boolean bl, int n, int n2) {
        if (!bl && n2 > 512) {
            n2 = 512;
        }
        if (byArray == null) {
            this.bInputBytes = new byte[0];
        } else if (n > byArray.length) {
            this.bInputBytes = new byte[0];
        } else if (n + n2 > byArray.length) {
            this.bInputBytes = new byte[byArray.length - n];
            System.arraycopy(byArray, n, this.bInputBytes, 0, this.bInputBytes.length);
        } else {
            this.bInputBytes = new byte[n2];
            System.arraycopy(byArray, n, this.bInputBytes, 0, n2);
        }
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer("\n");
        try {
            this.lOffset = 0L;
            byte[] byArray = new byte[16];
            int n = 0;
            while (this.lOffset < (long)this.bInputBytes.length) {
                int n2 = 16;
                if (this.lOffset + (long)n2 > (long)this.bInputBytes.length) {
                    n2 = (int)((long)this.bInputBytes.length - this.lOffset);
                }
                System.arraycopy(this.bInputBytes, (int)this.lOffset, byArray, 0, n2);
                this.printLine(stringBuffer, byArray, n2);
                this.lOffset += (long)n2;
                if (++n % 8 != 0) continue;
                stringBuffer.append("\n");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return stringBuffer.toString();
    }

    private void printLine(StringBuffer stringBuffer, byte[] byArray, int n) {
        char c;
        int n2;
        stringBuffer.append(" ");
        for (n2 = 0; n2 < 4; ++n2) {
            int c2 = (int)(this.lOffset >> 4 * (3 - n2)) % 16;
            if (c2 < 0) {
                c2 += 16;
            }
            c = c2 >= 0 && c2 <= 9 ? (char)(c2 + 48) : (char)(c2 - 10 + 65);
            stringBuffer.append(c);
        }
        stringBuffer.append(":  ");
        for (n2 = 0; n2 < n; ++n2) {
            int n3 = byArray[n2] & 0xFF;
            c = n3 / 16 >= 0 && n3 / 16 <= 9 ? (char)(n3 / 16 + 48) : (char)(n3 / 16 - 10 + 65);
            stringBuffer.append(c);
            c = n3 % 16 >= 0 && n3 % 16 <= 9 ? (char)(n3 % 16 + 48) : (char)(n3 % 16 - 10 + 65);
            stringBuffer.append(c);
            if ((n2 + 1) % 2 == 0) {
                stringBuffer.append(' ');
            }
            if ((n2 + 1) % 8 != 0) continue;
            stringBuffer.append(' ');
        }
        for (n2 = 0; n2 < (16 - n) * 2 + (8 - n / 2) + (2 - n / 8); ++n2) {
            stringBuffer.append(' ');
        }
        stringBuffer.append(" *");
        for (n2 = 0; n2 < n; ++n2) {
            char c2 = (char)byArray[n2];
            if (c2 >= ' ' && c2 <= '~') {
                stringBuffer.append(c2);
                continue;
            }
            stringBuffer.append('.');
        }
        for (n2 = n; n2 < 16; ++n2) {
            stringBuffer.append(' ');
        }
        stringBuffer.append("*\n");
    }

    public static void main(String[] stringArray) {
        byte[] byArray = new byte[]{-127, -126, -125, -124, -127, -126, -125, -124, -127, -126, -125, -124, -127, -126, -125, -124, -122, -121, -120, -119, -122, -121, -120, -119, -122, -121, -120, -119, -122, -121, -120, -119, -127, -126, -125, -124, -127, -126, -125, -124, -127, -126, -125, -124, -127, 1, 2, 3, 4, 127};
        if (stringArray.length == 1 && stringArray[0] != null) {
            try {
                System.out.println("HexDump of file: " + stringArray[0]);
                FileInputStream fileInputStream = new FileInputStream(stringArray[0]);
                byArray = new byte[fileInputStream.available()];
                fileInputStream.read(byArray);
            }
            catch (IOException iOException) {
                System.out.println(iOException);
            }
        }
        HexDump hexDump = new HexDump(byArray);
        System.out.println(hexDump);
    }
}

